unit DBViewer;

interface

////////////////////////////////////////////////////////////////////////////////
//  BDE .NET Demo
//  Written by Giuseppe Madaffari, giuseppe@giumad.com
//
//  ADVICE: this is just a example of BDE .NET. Note that BDE is now an old
//          technology and should not be used with new projects
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Globalization,
  Borland.Vcl.DBTables, Borland.Vcl.Classes;

type
  TWinForm1 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Panel1: System.Windows.Forms.Panel;
    DataGrid1: System.Windows.Forms.DataGrid;
    DataSet1: System.Data.DataSet;
    Label1: System.Windows.Forms.Label;
    ComboBox1: System.Windows.Forms.ComboBox;
    Button1: System.Windows.Forms.Button;
    Panel2: System.Windows.Forms.Panel;
    Button2: System.Windows.Forms.Button;
    SaveFileDialog1: System.Windows.Forms.SaveFileDialog;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ComboBox1_SelectionChangeCommitted(sender: System.Object; e: System.EventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    DBName: String;
    Pwd: String;
    procedure OnLogin(Database: TDatabase; LoginParams: TStrings);
  public
    constructor Create;
    procedure PopulateDataSet(const DBName, TableName: String);
    procedure CloneTableStructure(BDETable: TTable; ADOTable: DataTable);
    procedure LoadTableNames(const DBName: String);
    class procedure ShowForm(const ADBName: String);
  end;

implementation
uses Borland.Vcl.DB, Borland.Vcl.Dialogs;


{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm1.InitializeComponent;
begin
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.ComboBox1 := System.Windows.Forms.ComboBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.DataSet1 := System.Data.DataSet.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.SaveFileDialog1 := System.Windows.Forms.SaveFileDialog.Create;
  Self.Panel1.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataSet1)).BeginInit;
  Self.Panel2.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Panel1
  // 
  Self.Panel1.Controls.Add(Self.ComboBox1);
  Self.Panel1.Controls.Add(Self.Label1);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel1.Location := System.Drawing.Point.Create(0, 0);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(488, 40);
  Self.Panel1.TabIndex := 0;
  // 
  // ComboBox1
  // 
  Self.ComboBox1.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.ComboBox1.DropDownStyle := System.Windows.Forms.ComboBoxStyle.DropDownList;
  Self.ComboBox1.Location := System.Drawing.Point.Create(56, 8);
  Self.ComboBox1.Name := 'ComboBox1';
  Self.ComboBox1.Size := System.Drawing.Size.Create(424, 21);
  Self.ComboBox1.TabIndex := 1;
  Include(Self.ComboBox1.SelectionChangeCommitted, Self.ComboBox1_SelectionChangeCommitted);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(8, 11);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(40, 23);
  Self.Label1.TabIndex := 0;
  Self.Label1.Text := 'Table';
  // 
  // DataGrid1
  // 
  Self.DataGrid1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.DataGrid1.CaptionFont := System.Drawing.Font.Create('Microsoft Sans Serif', 10, System.Drawing.FontStyle.Bold);
  Self.DataGrid1.DataMember := '';
  Self.DataGrid1.DataSource := Self.DataSet1;
  Self.DataGrid1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGrid1.Location := System.Drawing.Point.Create(0, 41);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.Size := System.Drawing.Size.Create(488, 296);
  Self.DataGrid1.TabIndex := 1;
  // 
  // DataSet1
  // 
  Self.DataSet1.DataSetName := 'NewDataSet';
  Self.DataSet1.Locale := System.Globalization.CultureInfo.Create('it-IT');
  // 
  // Panel2
  // 
  Self.Panel2.Controls.Add(Self.Button2);
  Self.Panel2.Controls.Add(Self.Button1);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.Panel2.Location := System.Drawing.Point.Create(0, 341);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(488, 40);
  Self.Panel2.TabIndex := 3;
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(136, 8);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(144, 23);
  Self.Button2.TabIndex := 3;
  Self.Button2.Text := 'Save Schema File (XSD)';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(8, 8);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(112, 23);
  Self.Button1.TabIndex := 2;
  Self.Button1.Text := 'Save to XML File';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // SaveFileDialog1
  // 
  Self.SaveFileDialog1.Title := 'Save to file';
  // 
  // TWinForm1
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(488, 381);
  Self.Controls.Add(Self.Panel2);
  Self.Controls.Add(Self.DataGrid1);
  Self.Controls.Add(Self.Panel1);
  Self.Name := 'TWinForm1';
  Self.Text := 'BDE .NET DEMO DB Explorer';
  Self.Panel1.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataSet1)).EndInit;
  Self.Panel2.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm1.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm1.PopulateDataSet(const DBName, TableName: String);
var
  BDETable: TTable;
  ADOTable: DataTable;
  I: Integer;
  Row: DataRow;
  DB: TDatabase;
begin
  I := DataSet1.Tables.IndexOf(TableName);
  if I < 0 then   // is the first time for this table?
  begin
    DB := TDatabase.Create(nil);
    try
      DB.DatabaseName := DBName;
      DB.LoginPrompt := True;
      DB.OnLogin := OnLogin;
      DB.Open;
      BDETable := TTable.Create(nil);
      BDETable.DatabaseName := DB.DatabaseName;
      BDETable.TableName := TableName;
      BDETable.Open;
      // creates internal datatable
      AdoTable := DataSet1.Tables.Add;
      ADOTable.TableName := TableName;
      CloneTableStructure(BDETable, ADOTable);
      AdoTable.BeginLoadData;
      while not BDETable.Eof do
      begin
        Row := AdoTable.NewRow;
        for I := 0 to BDETable.FieldCount - 1 do
        try
          Row.set_Item(BDETable.Fields[I].FieldName, BDETable.Fields[I].AsString);
        except
        end;

        ADOTable.Rows.Add(Row);

        BDETable.Next;
      end;

      try
        // do silent any validation exception, the grid however will display red signs
        AdoTable.EndLoadData;
      except end;

      BDETable.Close;
    finally
      DB.Free;  // needed to free db resource and avoid duplicate
    end;
  end
  else
    ADOTable := DataSet1.Tables[I];

  // connect proper data to grid
  DataGrid1.DataSource := ADOTable;
  DataGrid1.CaptionText := DBName + ':' + TableName;
end;

procedure TWinForm1.CloneTableStructure(BDETable: TTable;
  ADOTable: DataTable);
var
  I: Integer;
begin
  for I := 0 to BDETable.FieldCount - 1 do
  begin
    with ADOTable.Columns.Add do
    begin
      // the following code has a limit: it only deals (and not properly!) with few data types
      case BDETable.Fields[I].DataType of
        ftString, ftWideString, ftUnknown, ftMemo,
        ftFixedChar: begin
          DataType := System.Type.GetType('System.String');
          MaxLength := BDETable.Fields[I].DataSize;
        end;
        ftBoolean: DataType := System.Type.GetType('System.Boolean');
        ftInteger, ftSmallint, ftAutoInc,
        ftWord: DataType := System.Type.GetType('System.Int16');
        ftLargeint: DataType := System.Type.GetType('System.Int64');
        ftFloat, ftCurrency: DataType := System.Type.GetType('System.Double');
        ftDateTime, ftDate: DataType := System.Type.GetType('System.DateTime');
        ftTime: DataType := System.Type.GetType('System.TimeSpan');
        ftBlob, ftGraphic: DataType := System.Type.GetType('System.Byte');
        // should continue... but it's a sample
        else begin
          DataType := System.Type.GetType('System.String');
          MaxLength := 10;   // just to limit data...
        end;
      end;

      ColumnName := BDETable.Fields[I].FieldName;
      ReadOnly := BDETable.Fields[I].ReadOnly;
      // more setup could be added...
    end;
  end;
end;

procedure TWinForm1.ComboBox1_SelectionChangeCommitted(sender: System.Object;
    e: System.EventArgs);
begin
  PopulateDataSet(DBName, ComboBox1.Text);
end;

class procedure TWinForm1.ShowForm(const ADBName: String);
begin
  with TWinForm1.Create do
  begin
    DBName := ADBName;
    LoadTableNames(DBName);
    ShowDialog;
  end;
end;

procedure TWinForm1.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  SaveFileDialog1.DefaultExt := 'xsd';
  SaveFileDialog1.Filter := 'XML Schema (*.xsd)|*.xsd';
  SaveFileDialog1.FileName := DBName;
  if SaveFileDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK then
  begin
    DataSet1.WriteXmlSchema(SaveFileDialog1.FileName);
    MessageBox.Show('Data written to disk');
  end;
end;

procedure TWinForm1.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  SaveFileDialog1.DefaultExt := 'xml';
  SaveFileDialog1.Filter := 'XML File (*.xml)|*.xml';
  SaveFileDialog1.FileName := DBName;
  if SaveFileDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK then
  begin
    DataSet1.WriteXml(SaveFileDialog1.FileName);
    MessageBox.Show('Data written to disk');
  end;
end;

procedure TWinForm1.LoadTableNames(const DBName: String);
var
  List: TStringList;
  I: Integer;
  DB: TDatabase;
begin
  DB := nil;  //avoids warning
  with TSession.Create(nil) do
  try
    AutoSessionName := True;
    DB := TDatabase.Create(nil);
    DB.DatabaseName := DBName;
    DB.SessionName := SessionName;
    DB.OnLogin := OnLogin;
    DB.Open;
    List := TStringList.Create;
    if GetAliasDriverName(DBName).Equals('STANDARD') then
      GetTableNames(DBName, '', True, False, List)
    else
      DB.GetTableNames(List);
    for I := 0 to List.Count - 1 do
      ComboBox1.Items.Add(List[I].ToUpper);
  finally
    // since we're dealing with BDE is better to free resource immediately
    DB.Free;
    Free;
    DataSet1.DataSetName := DBName;
  end;
end;

procedure TWinForm1.OnLogin(Database: TDatabase; LoginParams: TStrings);
begin
  if Pwd = '' then
    InputQuery('BDE Demo', 'Please provide a password:', Pwd);

  LoginParams.Add('Password=' + Pwd);
end;

end.
